// File: int_vect.h
//
// Description:  smart int vector
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI library
//       can not be distributed (on bulletin boards, or as part
//       of shareware or commercial products) without written
//       permission.
//

#ifndef __smart_vect
#define __smart_vect

#include "applib.h"

template<class T>
class vect {
  public:
    int num_elements;
    vect(void);
    vect (int n);
    vect(vect &v);
    vect(T a[], int n);
   ~vect() { delete p; }
    T & operator [] (int i);  // range check safeguards
    void save(char *filename);
    void restore(char *filename);
 private:
    T *p;
    int size;
    void grow(int new_size);
    int ub() { return (size - 1); }
};

#endif
